/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

static const char __idstring[] = "@(#)$Id: mx_strerror.c,v 1.28 2006/09/03 06:25:31 bgoglin Exp $";
 
#include "mx_auto_config.h"
#include "myriexpress.h"
#include "mx__shim.h"

MX_FUNC(const char *)
mx_strerror(mx_return_t return_code)
{
  static char buf[80];

  switch (return_code) {
  case MX_SUCCESS:
    return "Successful return.";
  case MX_ALREADY_INITIALIZED:
    return "MX already initialized.";
  case MX_NOT_INITIALIZED:
    return "MX not initialized.";
  case MX_BOARD_UNKNOWN:
    return "Board specified does not exist.";
  case MX_NO_DEV:
    return "No MX device entry in /dev.";
  case MX_NO_DRIVER:
    return "MX driver not loaded.";
  case MX_NO_PERM:
    return "Permission denied.";
  case MX_BAD_ENDPOINT:
    return "Endpoint is not valid.";
  case MX_BAD_SEG_LIST:
    return "Bad segment list.";
  case MX_BAD_SEG_MEM:
    return "One segment is invalid.";
  case MX_BAD_SEG_CNT:
    return "Too many segments.";
  case MX_BAD_MATCH_MASK:
    return "Bad match mask.";
  case MX_NO_RESOURCES:
    return "No resources.";
  case MX_BAD_ADDR_LIST:
    return "Bad address list.";
  case MX_BAD_ADDR_COUNT:
    return "Bad address count.";
  case MX_BAD_ROOT:
    return "Root index out of range.";
  case MX_NOT_COMPLETED:
    return "Not completed.";
  case MX_BUSY:
    return "Busy";
  case MX_TIMEOUT:
    return "Operation timed-out";
  case MX_BAD_INFO_KEY:
    return "Bad info key.";
  case MX_BAD_INFO_VAL:
    return "Bad info value pointer.";
  case MX_BAD_NIC:
    return "Bad nic id.";
  case MX_BAD_PARAM_LIST:
    return "Bad parameter list.";
  case MX_BAD_PARAM_NAME:
    return "Bad parameter name.";
  case MX_BAD_PARAM_VAL:
    return "Bad parameter value.";
  case MX_BAD_HOSTNAME_ARGS:
    return "Bad arguments to hostname_to_ni_ids";
  case MX_HOST_NOT_FOUND:
    return "Hostname not found";
  case MX_BAD_BAD_BAD:
    return "Failure querying MX driver(wrong driver?)";
  case MX_FAILURE:
    return "Failure!";
  case MX_CONNECTION_FAILED:
    return "Endpoint closed or not connectable!";
  case MX_BAD_CONNECTION_KEY:
    return "Endpoint access denied: wrong key!";
  case MX_BAD_INFO_LENGTH:
    return "Bad info length";
  case MX_NIC_NOT_FOUND:
    return "Destination NIC not found in network table";
  case MX_BAD_KERNEL_VERSION:
    return "MX library incompatible with driver version";
  case MX_BAD_LIB_VERSION:
    return "Linked-time MX library incompatible with compile-time myriexpress.h";
  case MX_NIC_DEAD:
    return "The NIC has stopped responding";
  case MX_CANCEL_NOT_SUPPORTED:
    return "Cancelling not supported on this kind of request";
  case MX_CLOSE_IN_HANDLER:
    return "Closing not allowed in the handler";
  case MX_BAD_MATCHING_FOR_CONTEXT_ID_MASK:
    return "Matching info does not respect context id mask";
  case MX_NOT_SUPPORTED_WITH_CONTEXT_ID:
    return "Feature not supported when context id are enabled";
  default:
    mx_sprintf(buf, "Unknown error code: %d", return_code);
    return buf;
  }
}

MX_FUNC(const char *)
mx_strstatus(mx_status_code_t status)
{
  static char buf[80];
  switch(status){
  case MX_STATUS_SUCCESS:
      return "Successful completion";
  case MX_STATUS_PENDING:
      return "Request still pending";
  case MX_STATUS_BUFFERED:
      return "Request has been buffered, but still pending";
  case MX_STATUS_REJECTED:
      return "Request has been rejected";
  case MX_STATUS_TIMEOUT:
      return "Posted operation timed out";
  case MX_STATUS_TRUNCATED:
      return "Data truncated due to undersized buffer";
  case MX_STATUS_CANCELLED:
      return "Panding receive was cancelled";
  case MX_STATUS_ENDPOINT_UNKNOWN:
      return "Destination endpoint is unknown on the network fabric";
  case MX_STATUS_ENDPOINT_CLOSED:
      return "Remote endpoint is closed";
  case MX_STATUS_ENDPOINT_UNREACHABLE:
      return "Connectivity is broken between the source and the destination";
  case MX_STATUS_BAD_SESSION:
      return "Bad session (missing mx_connect?)";
  case MX_STATUS_BAD_KEY:
      return "Wrong credentials";
  case MX_STATUS_BAD_ENDPOINT:
      return "Destination endpoint rank out of range";
  case MX_STATUS_BAD_RDMAWIN:
      return "Invalid rdma window";
  case MX_STATUS_ABORTED:
      return "Operation abort on peer nic";
  case MX_STATUS_EVENTQ_FULL:
      return "Internal eventq full";
  case MX_STATUS_NO_RESOURCES:
      return "Lack of internal resources";
  default:
    sprintf(buf, "Unknown status code: %d", status);
    return buf;
  }
}
